package unipotsdam.informatikkiste;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.method.CharacterPickerDialog;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

import java.util.LinkedList;

/**
 * A View, that displays a line of random Symbols in a vertical flow.
 */
public class FallingSymbolView extends View {

    /**
     * Is the speed of the Symbols in Pixels per Second
     */
    private static final float speed = 10f;

    private float symbolSize;

    private int symbolCount;
    private LinkedList<Character> symbolList;
    Paint symbolPaint;

    public FallingSymbolView(Context context) {
        super(context);
        init(null, 0);
    }

    public FallingSymbolView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs, 0);
    }

    public FallingSymbolView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.symbolList = new LinkedList<Character>();
        symbolPaint = new Paint();
        symbolPaint.setTextAlign(Paint.Align.CENTER);
        symbolPaint.setColor(Color.BLACK);
        symbolPaint.setTypeface(Typeface.create(symbolPaint.getTypeface(),Typeface.BOLD));
    }

    private void generateSymbols(){
        //determine size of Symbols
        final float testSize = 40f;
        final char[] testChar = {'M'};
        this.symbolPaint.setTextSize(testSize);
        Rect bounds = new Rect();
        this.symbolPaint.getTextBounds(testChar,0,1,bounds);

        Log.d("Koffer","TestWidth: " + bounds.width());

        this.symbolSize = testSize * this.getWidth() / bounds.width() * 0.75f;
        Log.d("Koffer","TextSize: " + this.symbolSize);
        this.symbolPaint.setTextSize(this.symbolSize);

        //initialise Symbols
        symbolCount = (int)(this.getHeight()/symbolSize)+1;
        Log.d("Koffer","SymbolCount: " + symbolCount);

        this.symbolList = new LinkedList<Character>();

        for(int i = 0; i < symbolCount; i++){
            Character c1 = (char)((int)((255-21)*Math.random()+21));
            Log.d("Koffer","Symbol: " + c1);
            symbolList.addLast(c1);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        canvas.drawColor(getResources().getColor(R.color.colorID_active));
        int centerX = this.getWidth()/2;

        for(int i = 0; i < symbolList.size(); i++){
            char[] chars = {symbolList.get(i)};
            canvas.drawText(chars,0,1,centerX,i*symbolSize,symbolPaint);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec){
        super.onMeasure(widthMeasureSpec,heightMeasureSpec);
        //TODO: set Measurement
        this.generateSymbols();
    }
}
